﻿var respondentFilter = {
    context: $(".v-respondentFilter"),
    initialize: function () {
        $(".h-dateTime", this.context).datetimepicker();

        $(".h-userAutoComplete", this.context).a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetOfflineSurveyUsers", "Analyze"),
            multipleSelection: true,
            hideSelectedItems: true,
            altValueField: $("#RespondentFilter_Users", this.context),
            resources: { "PlaceHolder": resources.AllUsers }
        });

        $(".v-customFieldConditions .v-dynamicEditor", this.context).a4dynamicGrid({
            addRow: function (e, d) {
                $(".h-customFieldAutoComplete", d.item).a4autocomplete({
                    ajaxAction: a4.getAction("GetCustomFields", "Distributions", "Settings"),
                    altValueField: $(".v-columnNumber", d.item),
                    valueProperty: "ColumnNumber",
                    labelProperty: "Name"
                });
            }
        });

        $(".v-assignedUsersSection", this.context).hide();
        $(".v-customRangeHour", this.context).hide();
    },
    bindEvents: function () {
        respondentFilter.context.on("change", ".h-checkAll", function () {
            var section = $(this).closest(".v-filterSection");
            $(":checkbox", section).prop("checked", $(this).prop("checked"));
        });

        respondentFilter.context.on("change", ":checkbox:not(.h-checkAll)", function () {
            var section = $(this).closest(".v-filterSection");
            $(".h-checkAll", section).prop("checked", false);
        });

        respondentFilter.context.on("change", "[name='RespondentFilter.LastActivity.OptionLastActivityType']", function () {
            var section = $(".v-rangeSelection", $(this).closest(".v-filterSection"));
            $("input[type=text]", section).val("");
        });

        respondentFilter.context.on("keyup", ".v-custom-range", function () {
            if ($(this).val() !== "") {
                var section = $(".today", $(this).closest(".v-filterSection"));
                $(".h-currentDate", section).prop("checked", false);
            }
        });

        respondentFilter.context.on("change", ".h-currentDate", function () {
            var section = $(".v-rangeSelection", $(this).closest(".v-filterSection"));
            $("input[type=text]", section).val("");
        });

        var section = $(".v-rangeSelection", $(this).closest(".v-filterSection"));

        respondentFilter.context.on("change", "input[type=text]", section, function () {
            if ($(this).val() !== "") {
                $("[name='RespondentFilter.LastActivity.OptionLastActivityType']").prop("checked", false);
            }
        });


        respondentFilter.context.on("change", "[name='RespondentFilter.EmailStatus']", function () {
            $("#email-min-max").toggle($(this).val() != "NoMailSent");

            var toggleTitle = $(":input[name='RespondentFilter.SMSStatus']", this.context).val() == "NoSMSSent" && $(this).val() == "NoMailSent";
            var title = $(".title", $("#email-min-max").closest(".v-filterSection"));
            $(title).toggle(!toggleTitle);
        });

        respondentFilter.context.on("change", "[name='RespondentFilter.SMSStatus']", function () {
            $("#sms-min-max").toggle($(this).val() != "NoSMSSent");

            var toggleTitle = $(":input[name='RespondentFilter.EmailStatus']", this.context).val() == "NoMailSent" && $(this).val() == "NoSMSSent";
            var title = $(".title", $("#sms-min-max").closest(".v-filterSection"));
            $(title).toggle(!toggleTitle);
        });

        respondentFilter.context.on("change", "[name='RespondentFilter.Offline.Assignment']", function () {
            $(".v-assignedUsersSection", respondentFilter.context).toggle($(this).val() == "Assigned");
        });

        respondentFilter.context.on("change", "[name='RespondentFilter.ExclusionList.Type']", function () {
            $(".v-exclusionListFilter-checkbox", respondentFilter.context).toggle($(this).val() != "None");

            $(".v-exclusionListFilter", respondentFilter.context).toggle($(".h-filter-using-subset", respondentFilter.context).is(":checked") && $(this).val() != "None");
        });

        respondentFilter.context.on("change", ".h-filter-using-subset", function () {
            $(".v-exclusionListFilter", respondentFilter.context).toggle($(this).is(":checked"));
        });

        respondentFilter.bindAdvancedFilteringEvents();

        $(".numeric", respondentFilter.context).each(function () {
            if ($(this).val() == -1) {
                $(this).val("");
            }
            $(this).autoNumeric({ aPad: false, vMin: '0', vMax: '9999', mDec: '0', aSep: '' });
        });

        respondentFilter.context.on("click", ".h-respondentFilterTypeSelector li", function () {
            var typeSelector = $(this).closest(".h-respondentFilterTypeSelector");
            var container = typeSelector.parent();
            var contentEditor = $(this).attr("data-editor");

            $("li.selected", typeSelector).removeClass("selected");
            $(this).addClass("selected");

            container.children(".v-contentContainer").hide();
            $(".v-contentContainer[data-editor='" + contentEditor + "']", container).show();
        });        
    },
    bindAdvancedFilteringEvents: function () {
        respondentFilter.context.on("click", ".h-toggleAdvancedFilterOptions", function () {
            var moreOptionsSection = $(".v-filter-moreOptionsSection", respondentFilter.context);
            moreOptionsSection.toggle();
            $("span.fa", $(this)).toggleClass("fa-caret-right fa-caret-down");
        });

        $(".v-dispositionAutoComplete").a4autocomplete({
            ajaxAction: a4.getAction("GetDispositionCodes", "Shared", "Home"),
            multipleSelection: true,
            hideSelectedItems: true,
            select: function (event, data) {
                if ($(this).a4autocomplete("getSelectedItemsCount") > 0) {
                    var range = $(".range-section", $(this).closest(".v-filterSection"));
                    var today = $(".today", $(this).closest(".v-filterSection"));

                    $(".numeric", range).attr("disabled", false);
                    $(".h-currentDate", today).attr("disabled", false);
                    $(".v-customDayRangeAutoComplete", $(this).closest(".v-filterSection")).attr("disabled", false);
                    $(".h-autocomplete-button", $(this).closest(".v-filterSection")).removeClass("disabled");
                }
            },
            removeItem: function (event, data) {
                if ($(this).a4autocomplete("getSelectedItemsCount") == 0) {
                    var range = $(".range-section", $(this).closest(".v-filterSection"));
                    var today = $(".today", $(this).closest(".v-filterSection"));

                    $(".numeric", range).attr("disabled", true);
                    $(".h-currentDate", today).attr("disabled", true);
                    $(".v-customDayRangeAutoComplete", $(this).closest(".v-filterSection")).attr("disabled", true);
                }
            }
        });

        $(".v-customDayRangeAutoComplete").a4autocomplete({
            valueProperty: "Id",
            labelProperty: "Name",
            data: [{ "Id": 0, "Name": resources.Days }, { "Id": 1, "Name": resources.Hours }],
            multipleSelection: false,
            hideSelectedItems: false,
            select: function (event, data) {
                var range = $(".range-section", $(this).closest(".v-filterSection"));
                var today = $(".today", $(this).closest(".v-filterSection"));

                $(".numeric", range).attr("disabled", false);
                $(".h-currentDate", today).attr("disabled", false);

                var customDayRangeField = $(".v-customDayRange", $(this).closest(".v-filterSection"));
                var customRangeHourRow = $(".v-customRangeHour", $(this).closest(".v-filterSection"));
                var customRangeDayRow = $(".v-customRangeDay", $(this).closest(".v-filterSection"));
                var dynamicTitle = $(".dynamic", $(this).closest(".v-filterSection"));

                if (customDayRangeField[0].dataset.value == 1) { // Hour
                    customRangeHourRow.show();
                    customRangeDayRow.hide();
                    $(".v-customRangeDay input", $(this).closest(".v-filterSection")).val("");
                    var filterName = customDayRangeField.attr('id').split('_')[1];
                    var from = filterName + "Days";
                    var to = filterName + "Hours";
                    var replacedString = dynamicTitle.text().replace(resources[from], resources[to]);
                    dynamicTitle.text(replacedString);
                } else {
                    customRangeHourRow.hide();
                    $(".v-customRangeHour input", $(this).closest(".v-filterSection")).val("");
                    customRangeDayRow.show();
                    var filterName = customDayRangeField.attr('id').split('_')[1];
                    var from = filterName + "Hours";
                    var to = filterName + "Days";
                    var replacedString = dynamicTitle.text().replace(resources[from], resources[to]);
                    dynamicTitle.text(replacedString);
                }
            }
        });

        $(".v-distributionAutocomplete").a4autocomplete({
            ajaxAction: a4.getSurveyAction("GetDistributionsForAutoComplete", "Distribute"),
            multipleSelection: true,
            hideSelectedItems: true,
            select: function (event, data) {
                if ($(this).a4autocomplete("getSelectedItemsCount") > 0) {
                    var range = $(".range-section", $(this).closest(".v-filterSection"));
                    var today = $(".today", $(this).closest(".v-filterSection"));

                    $(".numeric", range).removeAttr("disabled").prop("disabled", false);
                    $(".h-currentDate", today).removeAttr("disabled").prop("disabled", false);
                    $(".v-customDayRangeAutoComplete", $(this).closest(".v-filterSection")).removeAttr("disabled").prop("disabled", false);
                    $(".h-autocomplete-button", $(this).closest(".v-filterSection")).removeClass("disabled");
                }
            },
            removeItem: function (event, data) {
                if ($(this).a4autocomplete("getSelectedItemsCount") == 0) {
                    var range = $(".range-section", $(this).closest(".v-filterSection"));
                    var today = $(".today", $(this).closest(".v-filterSection"));

                    $(".numeric", range).attr("disabled", "disabled").prop("disabled", true);
                    $(".h-currentDate", today).attr("disabled", "disabled").prop("disabled", true);
                    $(".v-customDayRangeAutoComplete", $(this).closest(".v-filterSection")).removeAttr("disabled").prop("disabled", true);
                }
            }
        });
    },
    getFilter: function (callback, countRespondents, excludeEmptyEmails, excludeEmptyPhones) {
        var filter = {};

        filter.IsValid = true;
        filter.Definition = {};

        filter.Definition.Id = $('#RespondentFilter_Id').val();
        filter.Definition.ClientId = $('#ClientId').val();
        filter.Definition.SurveyId = $('#RespondentFilter_SurveyId', this.context).val() || a4.getSurveyId();
        filter.Definition.DispositionResults = $(':input[name="RespondentFilter.DispositionResults"]:checked', this.context).map(function () { return $(this).val(); }).get();
        filter.Definition.EmailDistributionStatuses = $(':input[name="RespondentFilter.EmailDistributionStatuses"]:checked', this.context).map(function () { return $(this).val(); }).get();
        filter.Definition.Languages = $(':input[name="RespondentFilter.Languages"]:checked', this.context).map(function () { return $(this).val(); }).get();
        filter.Definition.LanguagesCount = $(':input[name="RespondentFilter.Languages"]', this.context).length;

        filter.Definition.Devices = $(':input[name="RespondentFilter.Devices"]:checked', this.context).map(function () { return $(this).val(); }).get();
        filter.Definition.Samples = $(':input[name="RespondentFilter.Samples"]:checked', this.context).map(function () { return $(this).val(); }).get();
        filter.Definition.State = $(':input[name="RespondentFilter.State"]', this.context).val();
        filter.Definition.EmailStatus = $(':input[name="RespondentFilter.EmailStatus"]', this.context).val();

        filter.Definition.PersonalDataStatus = $(':input[name="RespondentFilter.PersonalDataStatus"]', this.context).val();

        filter.Definition.EmailNumberSent = {};
        filter.Definition.EmailNumberSent.minSent = $(':input[name="RespondentFilter.EmailNumberSent.minSent"]', this.context).val();
        filter.Definition.EmailNumberSent.maxSent = $(':input[name="RespondentFilter.EmailNumberSent.maxSent"]', this.context).val();
        filter.Definition.SMSStatus = $(':input[name="RespondentFilter.SMSStatus"]', this.context).val();
        filter.Definition.SMSNumberSent = {};
        filter.Definition.SMSNumberSent.minSent = $(':input[name="RespondentFilter.SMSNumberSent.minSent"]', this.context).val();
        filter.Definition.SMSNumberSent.maxSent = $(':input[name="RespondentFilter.SMSNumberSent.maxSent"]', this.context).val();
        filter.Definition.Expression = $(':input[name="RespondentFilter.Expression"]', this.context).val();

        filter.Definition.LastActivity = {};
        filter.Definition.LastActivity.OptionLastActivityType = $(':input[name="RespondentFilter.LastActivity.OptionLastActivityType"]:checked', this.context).val();
        filter.Definition.LastActivity.Begin = $(':input[name="RespondentFilter.LastActivity.Begin"]', this.context).val();
        filter.Definition.LastActivity.End = $(':input[name="RespondentFilter.LastActivity.End"]', this.context).val();

        filter.Definition.TerminatedSurvey = {};
        filter.Definition.TerminatedSurvey.DispositionCodes = _.pluck($(':input[name="RespondentFilter.TerminatedSurvey.DispositionCodes"]').a4autocomplete("getValue"), "Value");

        if ($(':input[name="RespondentFilter.TerminatedSurvey.UseCurrentDate"]', this.context).is(":checked")) {
            filter.Definition.TerminatedSurvey.UseCurrentDate = true;
        } else {
            filter.Definition.TerminatedSurvey.UseCurrentDate = false;
            filter.Definition.TerminatedSurvey.DayRangeType = $(':input[name="RespondentFilter.TerminatedSurvey.DayRangeType"]', this.context)[0].dataset.value;
            filter.Definition.TerminatedSurvey.MinDays = $(':input[name="RespondentFilter.TerminatedSurvey.MinDays"]', this.context).val();
            filter.Definition.TerminatedSurvey.MaxDays = $(':input[name="RespondentFilter.TerminatedSurvey.MaxDays"]', this.context).val();
            filter.Definition.TerminatedSurvey.MinHours = $(':input[name="RespondentFilter.TerminatedSurvey.MinHours"]', this.context).val();
            filter.Definition.TerminatedSurvey.MaxHours = $(':input[name="RespondentFilter.TerminatedSurvey.MaxHours"]', this.context).val();
        }

        filter.Definition.StartedSurvey = {};

        if ($(':input[name="RespondentFilter.StartedSurvey.UseCurrentDate"]', this.context).is(":checked")) {
            filter.Definition.StartedSurvey.UseCurrentDate = true;
        } else {
            filter.Definition.StartedSurvey.DayRangeType = $(':input[name="RespondentFilter.StartedSurvey.DayRangeType"]', this.context)[0].dataset.value;
            filter.Definition.StartedSurvey.MinDays = $(':input[name="RespondentFilter.StartedSurvey.MinDays"]', this.context).val();
            filter.Definition.StartedSurvey.MaxDays = $(':input[name="RespondentFilter.StartedSurvey.MaxDays"]', this.context).val();
            filter.Definition.StartedSurvey.MinHours = $(':input[name="RespondentFilter.StartedSurvey.MinHours"]', this.context).val();
            filter.Definition.StartedSurvey.MaxHours = $(':input[name="RespondentFilter.StartedSurvey.MaxHours"]', this.context).val();
        }

        filter.Definition.EmailSent = {};
        filter.Definition.EmailSent.DistributionIds = _.pluck($(':input[name="RespondentFilter.EmailSent.DistributionIds"]').a4autocomplete("getValue"), "Value");

        if ($(':input[name="RespondentFilter.EmailSent.UseCurrentDate"]', this.context).is(":checked")) {
            filter.Definition.EmailSent.UseCurrentDate = true;
        } else {
            filter.Definition.EmailSent.DayRangeType = $(':input[name="RespondentFilter.EmailSent.DayRangeType"]', this.context)[0].dataset.value;
            filter.Definition.EmailSent.MinDays = $(':input[name="RespondentFilter.EmailSent.MinDays"]', this.context).val();
            filter.Definition.EmailSent.MaxDays = $(':input[name="RespondentFilter.EmailSent.MaxDays"]', this.context).val();
            filter.Definition.EmailSent.MinHours = $(':input[name="RespondentFilter.EmailSent.MinHours"]', this.context).val();
            filter.Definition.EmailSent.MaxHours = $(':input[name="RespondentFilter.EmailSent.MaxHours"]', this.context).val();
        }

        filter.Definition.EmailReceived = {};
        filter.Definition.EmailReceived.DistributionIds = _.pluck($(':input[name="RespondentFilter.EmailReceived.DistributionIds"]').a4autocomplete("getValue"), "Value");

        filter.Definition.EmailNotReceived = {};
        filter.Definition.EmailNotReceived.DistributionIds = _.pluck($(':input[name="RespondentFilter.EmailNotReceived.DistributionIds"]').a4autocomplete("getValue"), "Value");

        if ($("#IsOfflineSurvey", this.context).val() == "True") {
            filter.Definition.IsOfflineSurvey = true;
            filter.Definition.Offline = {};
            filter.Definition.Offline.Location = $(':input[name="RespondentFilter.Offline.Location"]:checked', this.context).val();
            filter.Definition.Offline.Assignment = $(':input[name="RespondentFilter.Offline.Assignment"]:checked', this.context).val();
            filter.Definition.Offline.Users = _.pluck($(".h-userAutoComplete", this.context).a4autocomplete("getValue"), "Value");
        }

        filter.Definition.ExclusionList = {};
        filter.Definition.ExclusionList.FilterUsingASubsetOfTheList = $(".h-filter-using-subset").is(":checked");

        filter.Definition.ExclusionList.Type = $(':input[name="RespondentFilter.ExclusionList.Type"]', this.context).val();
        if ($(".h-filter-using-subset").is(":checked") && $(':input[name="RespondentFilter.ExclusionList.Type"]', this.context).val() != "None") {

            filter.Definition.ExclusionList.CurrentSurvey = $(':input[name="RespondentFilter.ExclusionList.CurrentSurvey"]', this.context).is(":checked");
            filter.Definition.ExclusionList.CustomFieldConditions = $(".v-customFieldConditions .v-dynamicEditor", this.context).a4dynamicGrid("getValue");
            //filter.Definition.ExclusionList.CustomFieldConditions.Operator = $(".v-customFieldConditions .v-dynamicEditor .v-logicOperator", this.context).val();
        }

        a4.callServerMethod(a4.getSurveyAction("ValidateRespondentFilter", "Shared"), { filter: JSON.stringify(filter.Definition), countRespondents: countRespondents, excludeEmptyEmails: excludeEmptyEmails, excludeEmptyPhones: excludeEmptyPhones },
        function (result) {
            filter.IsValid = result.IsValid;
            filter.Count = result.Count;
            filter.Summary = result.Summary;

            $(':input[name="RespondentFilter.Expression"]', this.context).toggleClass("input-validation-error", !filter.IsValid);

            if (callback) {
                callback(filter);
            }
        },
        function (error) { },
        { blockElement: respondentFilter.context });
    },
    setFilter: function (filter) {
                        
        $('#RespondentFilter_Id').val(filter.Definition.Id)
        $('#ClientId').val(filter.Definition.ClientId);
        $('#RespondentFilter_SurveyId', this.context).val(filter.Definition.SurveyId || a4.getSurveyId());

        
        $.each(filter.Definition.DispositionResults, function (i, val) {
            $('input[name="RespondentFilter.DispositionResults"][value="' + val + '"]', this.context).prop("checked", true);
        });

        $.each(filter.Definition.EmailDistributionStatuses, function (i, val) {
            $('input[name="RespondentFilter.EmailDistributionStatuses"][value="' + val + '"]', this.context).prop("checked", true);
        });

        $.each(filter.Definition.Languages, function (i, val) {
            $('input[name="RespondentFilter.Languages"][value="' + val + '"]', this.context).prop("checked", true);
        });

        $.each(filter.Definition.Devices, function (i, val) {
            $('input[name="RespondentFilter.Devices"][value="' + val + '"]', this.context).prop("checked", true);
        });
        
        $.each(filter.Definition.Samples, function (i, val) {
            $('input[name="RespondentFilter.Samples"][value="' + val + '"]', this.context).prop("checked", true);
        });

        $(':input[name="RespondentFilter.State"]', this.context).val(filter.Definition.State);
        $(':input[name="RespondentFilter.EmailStatus"]', this.context).val(filter.Definition.EmailStatus);
        $(':input[name="RespondentFilter.PersonalDataStatus"]', this.context).val(filter.Definition.PersonalDataStatus);
                
        $(':input[name="RespondentFilter.EmailNumberSent.minSent"]', this.context).val(filter.Definition.EmailNumberSent.minSent);
        $(':input[name="RespondentFilter.EmailNumberSent.maxSent"]', this.context).val(filter.Definition.EmailNumberSent.maxSent);
        $(':input[name="RespondentFilter.SMSStatus"]', this.context).val(filter.Definition.SMSStatus);
        
        $(':input[name="RespondentFilter.SMSNumberSent.minSent"]', this.context).val(filter.Definition.SMSNumberSent.minSent);
        $(':input[name="RespondentFilter.SMSNumberSent.maxSent"]', this.context).val(filter.Definition.SMSNumberSent.maxSent);
        $(':input[name="RespondentFilter.Expression"]', this.context).val(filter.Definition.Expression);

        $(':input[name="RespondentFilter.LastActivity.Begin"]', this.context).val(filter.Definition.LastActivity.Begin);
        $(':input[name="RespondentFilter.LastActivity.End"]', this.context).val(filter.Definition.LastActivity.End);

        if (filter.Definition.LastActivity.OptionLastActivityType == "Today")
            $('input[id = "RespondentFilter.LastActivity.OptionLastActivityType_Today"]', this.context).prop("checked", true);
        else
            if (filter.Definition.LastActivity.OptionLastActivityType == "CurrentMonth")
                $('input[id = "RespondentFilter.LastActivity.OptionLastActivityType_CurrentMonth"]', this.context).prop("checked", true);               
        
        $('input[name="RespondentFilter.TerminatedSurvey.DispositionCodes"]', this.context).a4autocomplete("setValue", filter.Definition.TerminatedSurvey.DispositionCodes);

        var dayRangeData = ["Days", "Hours"];

        if (filter.Definition.TerminatedSurvey.UseCurrentDate) {
            $(':input[type=checkbox][name="RespondentFilter.TerminatedSurvey.UseCurrentDate"]', this.context).prop("checked", true);
        } else {
            $(':input[name="RespondentFilter.TerminatedSurvey.MinDays"]', this.context).val(filter.Definition.TerminatedSurvey.MinDays);
            $(':input[name="RespondentFilter.TerminatedSurvey.MaxDays"]', this.context).val(filter.Definition.TerminatedSurvey.MaxDays);
            $(':input[type=checkbox][name="RespondentFilter.TerminatedSurvey.UseCurrentDate"]', this.context).prop("checked", false);
            var dayRangeType = filter.Definition.TerminatedSurvey.DayRangeType.length > 1 ? dayRangeData.indexOf(filter.Definition.TerminatedSurvey.DayRangeType) : filter.Definition.TerminatedSurvey.DayRangeType;
            $(':input[name="RespondentFilter.TerminatedSurvey.DayRangeType"]', this.context).a4autocomplete('setValue', dayRangeType);
            $(':input[name="RespondentFilter.TerminatedSurvey.MinHours"]', this.context).val(filter.Definition.TerminatedSurvey.MinHours);
            $(':input[name="RespondentFilter.TerminatedSurvey.MaxHours"]', this.context).val(filter.Definition.TerminatedSurvey.MaxHours);
        }

        if (filter.Definition.StartedSurvey.UseCurrentDate) {
            $(':input[type=checkbox][name="RespondentFilter.StartedSurvey.UseCurrentDate"]', this.context).prop("checked", true);
        } else {
            $(':input[name="RespondentFilter.StartedSurvey.MinDays"]', this.context).val(filter.Definition.StartedSurvey.MinDays);
            $(':input[name="RespondentFilter.StartedSurvey.MaxDays"]', this.context).val(filter.Definition.StartedSurvey.MaxDays);
            $(':input[type=checkbox][name="RespondentFilter.StartedSurvey.UseCurrentDate"]', this.context).prop("checked", false);
            var dayRangeType = filter.Definition.StartedSurvey.DayRangeType.length > 1 ? dayRangeData.indexOf(filter.Definition.StartedSurvey.DayRangeType) : filter.Definition.StartedSurvey.DayRangeType;
            $(':input[name="RespondentFilter.StartedSurvey.DayRangeType"]', this.context).a4autocomplete('setValue', dayRangeType);
            $(':input[name="RespondentFilter.StartedSurvey.MinHours"]', this.context).val(filter.Definition.StartedSurvey.MinHours);
            $(':input[name="RespondentFilter.StartedSurvey.MaxHours"]', this.context).val(filter.Definition.StartedSurvey.MaxHours);
        }

        $(':input[name="RespondentFilter.EmailSent.DistributionIds"]').a4autocomplete("setValue", filter.Definition.EmailSent.DistributionIds);
        
        if (filter.Definition.EmailSent.UseCurrentDate) {
            $(':input[type=checkbox][name="RespondentFilter.EmailSent.UseCurrentDate"]', this.context).prop("checked", true);
        } else {
            $(':input[name="RespondentFilter.EmailSent.MinDays"]', this.context).val(filter.Definition.EmailSent.MinDays);
            $(':input[name="RespondentFilter.EmailSent.MaxDays"]', this.context).val(filter.Definition.EmailSent.MaxDays);
            $(':input[type=checkbox][name="RespondentFilter.EmailSent.UseCurrentDate"]', this.context).prop("checked", false);
            var dayRangeType = filter.Definition.EmailSent.DayRangeType.length > 1 ? dayRangeData.indexOf(filter.Definition.EmailSent.DayRangeType) : filter.Definition.EmailSent.DayRangeType;
            $(':input[name="RespondentFilter.EmailSent.DayRangeType"]', this.context).a4autocomplete('setValue', dayRangeType);
            $(':input[name="RespondentFilter.EmailSent.MinHours"]', this.context).val(filter.Definition.EmailSent.MinHours);
            $(':input[name="RespondentFilter.EmailSent.MaxHours"]', this.context).val(filter.Definition.EmailSent.MaxHours);
        }

        $(':input[name="RespondentFilter.EmailReceived.DistributionIds"]').a4autocomplete("setValue", filter.Definition.EmailReceived.DistributionIds);

        $(':input[name="RespondentFilter.EmailNotReceived.DistributionIds"]').a4autocomplete("setValue", filter.Definition.EmailNotReceived.DistributionIds);

        if (filter.Definition.IsOfflineSurvey) {
            $("#IsOfflineSurvey", this.context).val("True");

            if (filter.Definition.Offline.Location == "All")
                $('input[id = "RespondentFilter.Offline.Location_All"]', this.context).prop("checked", true);
            else
                if (filter.Definition.Offline.Location == "Server")
                    $('input[id = "RespondentFilter.Offline.Location_Server"]', this.context).prop("checked", true);
            else
                if (filter.Definition.Offline.Location == "Device")
                    $('input[id = "RespondentFilter.Offline.Location_Device"]', this.context).prop("checked", true);

            if (filter.Definition.Offline.Assignment == "All")
                $('input[id = "RespondentFilter.Offline.Assignment_All"]', this.context).prop("checked", true);
            else
                if (filter.Definition.Offline.Assignment == "Unassigned")
                    $('input[id = "RespondentFilter.Offline.Assignment_Unassigned"]', this.context).prop("checked", true);
                else
                    if (filter.Definition.Offline.Assignment == "Assigned") {
                        $('input[id = "RespondentFilter.Offline.Assignment_Assigned"]', this.context).prop("checked", true);
                        $('input[id = "RespondentFilter.Offline.Assignment_Assigned"]', this.context).trigger("change");
                    }
                        
            $(".h-userAutoComplete", this.context).a4autocomplete("setValue", filter.Definition.Offline.Users);            
        }

        if (filter.Definition.ExclusionList.FilterUsingASubsetOfTheList)
            $(".h-filter-using-subset").prop("checked", true);
        

        $(':input[name="RespondentFilter.ExclusionList.Type"]', this.context).val(filter.Definition.ExclusionList.Type);
        $(':input[name="RespondentFilter.ExclusionList.Type"]', this.context).trigger("change");
        if (filter.Definition.ExclusionList.FilterUsingASubsetOfTheList && filter.Definition.ExclusionList.Type != "None") {

            $(':input[type=checkbox][name="RespondentFilter.ExclusionList.CurrentSurvey"]', this.context).prop("checked", filter.Definition.ExclusionList.CurrentSurvey);
            $(':input[type=checkbox][name="RespondentFilter.ExclusionList.FilterUsingASubsetOfTheList"]', this.context).prop("checked", filter.Definition.ExclusionList.FilterUsingASubsetOfTheList);
            $(':input[type=checkbox][name="RespondentFilter.ExclusionList.FilterUsingASubsetOfTheList"]', this.context).trigger("change");
            

            $(".v-customFieldConditions .v-dynamicEditor", this.context).a4dynamicGrid("setValue", filter.Definition.ExclusionList.CustomFieldConditions);            
        }        
    },
    clearFilter: function () {
        $(':input[name="RespondentFilter.DispositionResults"]:checked', this.context).prop("checked", false);
        $(':input[name="RespondentFilter.EmailDistributionStatuses"]:checked', this.context).prop("checked", false);
        $(':input[name="RespondentFilter.Languages"]:checked', this.context).prop("checked", false);
        $(':input[name="RespondentFilter.Devices"]:checked', this.context).prop("checked", false);
        $(':input[name="RespondentFilter.Samples"]:checked', this.context).prop("checked", false);
        $(':input[name="RespondentFilter.State"]', this.context).val("All").trigger("change");
        $(':input[name="RespondentFilter.EmailStatus"]', this.context).val("All").trigger("change");
        $(':input[name="RespondentFilter.SMSStatus"]', this.context).val("All").trigger("change");

        $(".h-checkAll", this.context).prop("checked", false);

        $(':input[name="RespondentFilter.EmailNumberSent.minSent"]', this.context).val("");
        $(':input[name="RespondentFilter.EmailNumberSent.maxSent"]', this.context).val("");
        $("#email-min-max").toggle(true);

        $(':input[name="RespondentFilter.SMSNumberSent.minSent"]', this.context).val("");
        $(':input[name="RespondentFilter.SMSNumberSent.maxSent"]', this.context).val("");
        $("#sms-min-max").toggle(true);

        $(':input[name="RespondentFilter.Expression"]', this.context).val("");
        $(':input[name="RespondentFilter.LastActivity.OptionLastActivityType"][value="Today"]', this.context).prop("checked", false);
        $(':input[name="RespondentFilter.LastActivity.OptionLastActivityType"][value="CurrentMonth"]', this.context).prop("checked", false);

        $('.v-rangeSelection', this.context).toggle(true);

        $(':input[name="RespondentFilter.LastActivity.Begin"]', this.context).val("");
        $(':input[name="RespondentFilter.LastActivity.End"]', this.context).val("");

        $(':input[name="RespondentFilter.State"][value="All"]', this.context).prop("checked", true);
        $(':input[name="RespondentFilter.EmailStatus"][value="All"]', this.context).prop("checked", true);
        $(':input[name="RespondentFilter.SMSStatus"][value="All"]', this.context).prop("checked", true);

        $(':input[name="RespondentFilter.TerminatedSurvey.MinDays"]', this.context).val("");
        $(':input[name="RespondentFilter.TerminatedSurvey.MaxDays"]', this.context).val("");
        $(':input[name="RespondentFilter.TerminatedSurvey.MinHours"]', this.context).val("");
        $(':input[name="RespondentFilter.TerminatedSurvey.MaxHours"]', this.context).val("");
        $(':input[name="RespondentFilter.StartedSurvey.MinDays"]', this.context).val("");
        $(':input[name="RespondentFilter.StartedSurvey.MaxDays"]', this.context).val("");
        $(':input[name="RespondentFilter.StartedSurvey.MinHours"]', this.context).val("");
        $(':input[name="RespondentFilter.StartedSurvey.MaxHours"]', this.context).val("");
        $(':input[name="RespondentFilter.EmailSent.MinDays"]', this.context).val("");
        $(':input[name="RespondentFilter.EmailSent.MaxDays"]', this.context).val("");
        $(':input[name="RespondentFilter.EmailSent.MinHours"]', this.context).val("");
        $(':input[name="RespondentFilter.EmailSent.MaxHours"]', this.context).val("");
        $(".v-dispositionAutoComplete").a4autocomplete("clearValue");
        $(".v-distributionAutocomplete").a4autocomplete("clearValue");
        $(".v-customDayRangeAutoComplete").a4autocomplete("setValue", 0);
        $(".h-currentDate", this.context).prop("checked", false);
        $(".v-customDayRangeAutoComplete:not(.standalone)").prop("disabled", true);


        if ($("#IsOfflineSurvey", this.context).val() == "True") {
            $(':input[name="RespondentFilter.Offline.Location"][value="All"]', this.context).prop("checked", true);
            $(':input[name="RespondentFilter.Offline.Assignment"][value="All"]', this.context).prop("checked", true);
            $(".h-userAutoComplete", this.context).a4autocomplete("clearValue");
            $(".v-assignedUsersSection", this.context).hide();
        }

        $(':input[name="RespondentFilter.ExclusionList.Type"]', this.context).val("None").trigger("change");
        $(':input[name="RespondentFilter.ExclusionList.CurrentSurvey"]', this.context).prop("checked", false);
        $('.h-filter-using-subset', this.context).prop("checked", false);
        $(".v-exclusionListFilter", this.context).toggle(false);
        $(".v-customFieldConditions .v-dynamicEditor", this.context).a4dynamicGrid("clearValue");
    }
}

$(document).ready(function () {
    if (respondentFilter.context.length > 0) {
        respondentFilter.initialize();
        respondentFilter.bindEvents();

        var filterDefinition = $("#RespondentFilterDefinition", a4.top().document).val();
        if (filterDefinition != "" && typeof filterDefinition != "undefined")
            respondentFilter.setFilter({ Definition: JSON.parse(filterDefinition) });
    }
});